/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.TrellisBlock;
import cloud.lemonslice.teastory.block.crops.TrellisWithVineBlock;
import cloud.lemonslice.teastory.block.crops.VinePair;
import cloud.lemonslice.teastory.block.crops.VineType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;

public final class VineInfoManager {
    private static final Map<VinePair, TrellisWithVineBlock> TRELLIS_VINES_INFO = new HashMap<VinePair, TrellisWithVineBlock>();
    private static final Map<TrellisWithVineBlock, TrellisBlock> TRELLIS_INFO = new HashMap<TrellisWithVineBlock, TrellisBlock>();

    public static void registerVineTypeConnections(VineType typeIn, TrellisBlock blockIn, TrellisWithVineBlock vineOut) {
        TRELLIS_VINES_INFO.put(new VinePair(typeIn, blockIn), vineOut);
        TRELLIS_INFO.put(vineOut, blockIn);
    }

    public static void initTrellisBlocks() {
    }

    public static TrellisWithVineBlock getVineTrellis(VineType typeIn, TrellisBlock blockIn) {
        return TRELLIS_VINES_INFO.get(new VinePair(typeIn, blockIn));
    }

    public static TrellisBlock getEmptyTrellis(Block blockIn) {
        if (blockIn instanceof TrellisWithVineBlock) {
            return TRELLIS_INFO.getOrDefault(blockIn, null);
        }
        return null;
    }
}

